//
//  AppDelegate.m
//  iOSSampleApp
//
//  Copyright © 2020 Microsoft. All rights reserved.
//

#import "AppDelegate.h"
#import <EIObjC/EIObjC.h>

@interface AppDelegate ()

@end

@implementation AppDelegate

/*
    To enable or disable the auto-collection feature for tracking action
    and view events set the following boolean fields in the
    EIConfig.plist file to YES (1) (enable) or NO (0) (disable):
        autocollectAction
        autocollectView
 
    To test a zero-code auto-instrumentation set the following fields in
    the EIConfig.plist file and either comment out or delete all of the
    code below as well as comment out the above line: #import <EIObjC/EIObjC.h>:
        autocollectAction = YES (1)
        autocollectView = YES (1)
        ingestionKey = YOUR-INGESTION-KEY
*/

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {

    /*
     OPTIONAL: To track a custom event, please follow the steps below.
     */
    
    // 1.
    // To initialize the EIAnalytics you may either set the 'ingestionKey' field in the
    // EIConfig.plist file with your unique ingestion key and leave nil in the
    // ingestionKey parameter in the initialization method, or you may directly enter
    // your ingestion key in the parameter replacing nil
    NSError* error = nil;
    id<EIIAnalytics> analytics = [EIAnalyticsProvider analyticsForIngestionKey:nil error:&error];

    // 2.
    // Add custom properties to EIAnalytics instance that will apply to all events
    [analytics setValue:[NSUUID new] forKey:@"Analytics.Id"];
    [analytics setDoubleValue:2.1 forKey:@"App.Version"];

    // 3.
    // Add an EIUser to EIAnalytics instance that will apply to all events
    EIUser *user = [EIUser new];
    user.name = @"Clippy Art";
    user.localId = [[NSUUID new] UUIDString];
    user.email = @"clippy.a@mail.com";
    [analytics setUser:user];

    // 4.
    // Create and name a custom event to track.
    // Add optional properties which will override the custom properties added to the EIAnalytics instance
    EIEvent *event = [EIEvent new];
    event.name = @"SampleAppEvent";
    event.timestamp = [NSDate new];
    [event setValue:@"FinishedLaunching" forKey:@"App.Stage"];
    [event setBoolValue:YES forKey:@"App.Launch.Success"];

    // 5.
    // track the custom event
    [analytics trackEvent:event];

    return YES;
}


@end
