//
//  EIEvent.h
//  Copyright © 2020 Microsoft. All rights reserved.
//

#import <Foundation/Foundation.h>

// The set of attributes for Engagement Insights data for
// all observational data. This interface exposes the
// properties in an Engagement Insights event.

@interface EIEvent : NSObject

@property (atomic, copy) NSString* _Nonnull name;
@property (atomic, copy) NSDate* _Nullable timestamp;
@property (atomic, copy) NSString* _Nullable timezone;
@property (atomic, copy) NSString* _Nullable version;
@property (atomic, strong) NSMutableDictionary<NSString*, NSObject*>* _Nullable properties;

/*!
@brief Overrides the ingestion key passed in during initialization of Analytics for this event only.
*/
@property (atomic, copy) NSString* _Nullable ingestionKey;

-(nonnull NSString *)description;
-(instancetype _Nullable )init;
-(void)dealloc;

/*!
@brief Adds (or overrides) a property of the event for the telemetry tracking system.
Property information applies to this specific event.
@param value Contains the desired property value. The supported value types are NSString, NSDate and NSUUID.
@param key A string that contains the name of the property.
*/
-(void)setValue:(nullable id)value forKey:(nonnull NSString *)key;

/*!
 @brief Adds (or overrides) a property of the event for the telemetry tracking system.
 Property information applies to this specific event.
 @param key A string that contains the name of the property.
 @param value A boolean that contains the property value.
 */
-(void)setBoolValue:(BOOL)value forKey:(nonnull NSString *)key;

/*!
 @brief Adds (or overrides) a property of the event for the telemetry tracking system.
 Property information applies to this specific event.
 @param key A string that contains the name of the property.
 @param value A double that contains the property value.
 */
-(void)setDoubleValue:(double)value forKey:(nonnull NSString *)key;

/*!
 @brief Adds (or overrides) a property of the event for the telemetry tracking system.
 Property information applies to this specific event.
 @param key A string that contains the name of the property.
 @param value An int64_t that contains the property value.
 */
-(void)setLongValue:(int64_t)value forKey:(nonnull NSString *)key;

@end
