#ifndef AnalyticsProvider_h
#define AnalyticsProvider_h

//
//  Copyright (c) 2020 Microsoft. All rights reserved.
//

#import "IAnalytics.h"

#import <Foundation/Foundation.h>

/// <summary>
/// </summary>
@interface EIAnalyticsProvider : NSObject

#pragma mark EI SDK API
/// <summary>
/// Gets the Analytics with the current configuration.
/// The same Analytics is returned for the same ingestionKey specified.
/// Able to use the ingestionKey provided in the pList by passing null in the parameter.
/// **NOTE: If a null value is passed in the ingestionKey parameter, please check the returned value
/// to ensure the EIAnalytics class was returned. If a null value is returned, the ingestionKey value
/// in the .pList may not have been entered correctly.**
/// <param name="ingestionKey">Ingestion Key.</param>
/// <param name="error">Out parameter to indicate any error or partial success.</param>
/// </summary>
+ (nullable id<EIIAnalytics>)analyticsForIngestionKey:(nullable NSString *)ingestionKey error:(NSError *_Nullable *_Nullable)error;

/*!
 @brief Sets a value for the specified key.
*/
+ (void)setValue:(nullable id)value forKey:(nonnull NSString *)key;

/*!
 @brief Returns the value of the specified key.
*/
+ (nullable id)valueForKey:(nonnull NSString *)key;

@end

#endif // AnalyticsProvider_h
