package com.example.eitestapp

import android.content.Intent
import android.os.Bundle
import android.widget.Button
import androidx.appcompat.app.AppCompatActivity
import com.microsoft.engagementinsights.Action
import com.microsoft.engagementinsights.Analytics
import com.microsoft.engagementinsights.Event
import com.microsoft.engagementinsights.User
import com.microsoft.engagementinsights.core.ActionType

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        /** ==================================================================================
         *  =========== please see AndroidManifest.xml for configuration information =========
         * ===================================================================================
         */
        // Initialize Analytics
        var analytics = Analytics()

        // Set property on the Analytics level for all events
        analytics.setProperty("brand", "microsoft")

        // Set user information on the Analytics level
        var user = User()
        user.name = "testuser"
        user.email = "abc@xyz.com"
        analytics.setUser(user)

        // Set property on the individual event level
        var event = Event("video.log")
        event.version = "1"
        event.setProperty("duration", 320)
        event.setProperty("ad_shown", true)

        // Track event
        analytics.trackEvent(event)

        // If auto capture is enabled, landing on the next page will invoke another "view" event
        var button: Button = findViewById(R.id.button)
        button.setOnClickListener {
            val intent = Intent(this, HelloActivity::class.java)
            startActivity(intent)

            // Track an action event
            var clickAction = Action()
            clickAction.name = "click"
            clickAction.viewTarget = "HelloActivity"
            clickAction.type = ActionType.TAP
            analytics.trackAction(clickAction)
        }
    }
}
